import 'package:admin_desktop/domain/repository/booking_statistics_repository.dart';
import 'package:admin_desktop/domain/repository/form_option_repository.dart';
import 'package:admin_desktop/domain/repository/impl/booking_statistics_repository_impl.dart';
import 'package:admin_desktop/domain/repository/impl/form_option_repository_impl.dart';
import 'package:admin_desktop/presentation/routes/app_router.dart';
import 'package:get_it/get_it.dart';
import '../handlers/http_service.dart';
import '../repository/repository.dart';


final GetIt getIt = GetIt.instance;

void setUpDependencies() {
  getIt.registerSingleton<AppRouter>(AppRouter());
  getIt.registerLazySingleton<HttpService>(() => HttpService());
  getIt.registerSingleton<SettingsRepository>(SettingsSettingsRepositoryImpl());
  getIt.registerSingleton<AuthRepository>(AuthRepositoryImpl());
  getIt.registerSingleton<ProductsRepository>(ProductsRepositoryImpl());
  getIt.registerSingleton<ShopsRepository>(ShopsRepositoryImpl());
  getIt.registerSingleton<BrandsRepository>(BrandsRepositoryImpl());
  getIt.registerSingleton<GalleryRepositoryFacade>(GalleryRepository());
  getIt.registerSingleton<CategoriesRepository>(CategoriesRepositoryImpl());
  getIt.registerSingleton<CurrenciesRepository>(CurrenciesRepositoryImpl());
  getIt.registerSingleton<AddressRepository>(AddressRepositoryImpl());
  getIt.registerSingleton<PaymentsFacade>(PaymentsRepositoryImpl());
  getIt.registerSingleton<OrdersRepository>(OrdersRepositoryImpl());
  getIt.registerSingleton<NotificationRepository>(NotificationRepositoryImpl());
  getIt.registerSingleton<UsersFacade>(UsersRepositoryImpl());
  getIt.registerSingleton<CommentsRepository>(CommentsRepositoryImpl());
  getIt.registerSingleton<WalletRepository>(WalletRepositoryImpl());
  getIt.registerSingleton<StoriesRepository>(StoriesRepositoryImpl());
  getIt.registerSingleton<AdsRepository>(AdsRepositoryImpl());
  getIt.registerSingleton<DiscountsRepository>(DiscountsRepositoryImpl());
  getIt.registerSingleton<StockRepository>(StockRepositoryImpl());
  getIt.registerSingleton<SubscriptionsRepository>(SubscriptionsRepositoryImpl());
  getIt.registerSingleton<LooksRepository>(LooksRepositoryImpl());
  getIt.registerSingleton<ServiceMasterFacade>(ServiceMasterRepositoryImpl());
  getIt.registerSingleton<ServiceFacade>(ServiceRepositoryImpl());
  getIt.registerSingleton<BookingsFacade>(BookingsRepositoryImpl());
  getIt.registerSingleton<MembershipRepository>(MembershipRepositoryImpl());
  getIt.registerSingleton<MastersRepository>(MastersRepositoryImpl());
  getIt.registerSingleton<GiftCardRepository>(GiftCardRepositoryImpl());
  getIt.registerSingleton<FormOptionRepository>(FormOptionRepositoryImpl());
  getIt.registerSingleton<BookingsStatisticsFacade>(BookingStatisticsRepositoryImpl());
 // getIt.registerSingleton<ServiceMasterFacade>(ServiceMasterRepositoryImpl());
}

final appRouter = getIt.get<AppRouter>();
final dioHttp = getIt.get<HttpService>();
final settingsRepository = getIt.get<SettingsRepository>();
final authRepository = getIt.get<AuthRepository>();
final productsRepository = getIt.get<ProductsRepository>();
final shopsRepository = getIt.get<ShopsRepository>();
final brandsRepository = getIt.get<BrandsRepository>();
final galleryRepository = getIt.get<GalleryRepositoryFacade>();
final categoriesRepository = getIt.get<CategoriesRepository>();
final currenciesRepository = getIt.get<CurrenciesRepository>();
final addressRepository = getIt.get<AddressRepository>();
final commentsRepository = getIt.get<CommentsRepository>();
final paymentsRepository = getIt.get<PaymentsFacade>();
final walletRepository = getIt.get<WalletRepository>();
final ordersRepository = getIt.get<OrdersRepository>();
final notificationRepository = getIt.get<NotificationRepository>();
final usersRepository = getIt.get<UsersFacade>();
final storiesRepository = getIt.get<StoriesRepository>();
final adsRepository = getIt.get<AdsRepository>();
final discountRepository = getIt.get<DiscountsRepository>();
final stockRepository = getIt.get<StockRepository>();
final subscriptionRepository = getIt.get<SubscriptionsRepository>();
final looksRepository = getIt.get<LooksRepository>();
final serviceMasterRepository = getIt.get<ServiceMasterFacade>();
final serviceRepository = getIt.get<ServiceFacade>();
final bookingRepository = getIt.get<BookingsFacade>();
final membershipRepository = getIt.get<MembershipRepository>();
final mastersRepository = getIt.get<MastersRepository>();
final giftCardRepository = getIt.get<GiftCardRepository>();
final formRepository = getIt.get<FormOptionRepository>();
final bookingStatisticsRepository=getIt.get<BookingsStatisticsFacade>();